/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class JarExtractor {
    private Hashtable m_sizes = new Hashtable();
    private Hashtable m_jarContents = new Hashtable();
    private String m_jarFileName;

    public JarExtractor(String string) throws FileNotFoundException {
        this.m_jarFileName = string;
        if (!new File(this.m_jarFileName).exists()) {
            throw new FileNotFoundException(this.m_jarFileName);
        }
        this.initialize();
    }

    public byte[] getImageData(String string) {
        return (byte[])this.m_jarContents.get(string);
    }

    private void initialize() {
        ZipFile zipFile = null;
        try {
            Object object;
            zipFile = new ZipFile(this.m_jarFileName);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                this.m_sizes.put(((ZipEntry)object).getName(), new Integer((int)((ZipEntry)object).getSize()));
            }
            zipFile.close();
            zipFile = null;
            object = new FileInputStream(this.m_jarFileName);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                int n = (int)zipEntry.getSize();
                if (n == -1) {
                    n = (Integer)this.m_sizes.get(zipEntry.getName());
                }
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (n - n2 > 0 && (n3 = zipInputStream.read(byArray, n2, n - n2)) != -1) {
                    n2 += n3;
                }
                this.m_jarContents.put(zipEntry.getName(), byArray);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

