/*
 * Decompiled with CFR 0.152.
 */
package lawnlogin.updater;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import lawnlogin.FormWorker;
import util.StringUtils;

public class Updater {
    public static final String updateURL = "http://justin.fiores.net/files/LawnLoginX/LawnLoginXUpdate.txt";
    public static final String lawnLoginXJarURL = "http://justin.fiores.net/files/LawnLoginX/lawnLoginX.jar";
    public static final String lawnLoginXJarMD5URL = "http://justin.fiores.net/files/LawnLoginX/lawnLoginX.jar.md5";
    public static final String groovyJarURL = "http://justin.fiores.net/files/LawnLoginX/groovy-all.jar";
    public static final String groovyJarMD5URL = "http://justin.fiores.net/files/LawnLoginX/groovy-all.jar.md5";
    public static final String resourcesJarURL = "http://justin.fiores.net/files/LawnLoginX/resources.jar";
    public static final String resourcesJarMD5URL = "http://justin.fiores.net/files/LawnLoginX/resources.jar.md5";

    public static boolean checkForUpdate() throws Exception {
        String string = "1.0.1";
        String string2 = null;
        String[] stringArray = string.split("\\.");
        try {
            string2 = FormWorker.httpGet(updateURL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Exception("Couldn't Find Updater File: " + fileNotFoundException.getMessage());
        }
        String[] stringArray2 = string2.split("\\.");
        boolean bl = false;
        int n = stringArray.length >= stringArray2.length ? stringArray.length : stringArray2.length;
        for (int i = 0; i < n; ++i) {
            if (i >= stringArray.length) {
                bl = true;
                break;
            }
            if (i >= stringArray2.length || Integer.parseInt(stringArray2[i]) <= Integer.parseInt(stringArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    public static void update() throws Exception {
        String string = FormWorker.httpGet(lawnLoginXJarMD5URL);
        String string2 = FormWorker.httpGet(groovyJarMD5URL);
        String string3 = FormWorker.httpGet(resourcesJarMD5URL);
        Updater.downloadFile(lawnLoginXJarURL, "lawnLoginX.jar.tmp", string);
        Updater.downloadFile(groovyJarURL, "groovy-all.jar.tmp", string2);
        Updater.downloadFile(resourcesJarURL, "resources.jar.tmp", string3);
        Updater.moveFile("lawnLoginX.jar.tmp", "lawnLoginX.jar");
        Updater.moveFile("groovy-all.jar.tmp", "groovy-all.jar");
        Updater.moveFile("resources.jar.tmp", "resources.jar");
    }

    private static void moveFile(String string, String string2) throws Exception {
        if (!new File(string).renameTo(new File(string2))) {
            throw new Exception("File Rename failed for: " + string);
        }
    }

    private static void downloadFile(String string, String string2, String string3) throws Exception {
        int n;
        InputStream inputStream = FormWorker.httpGetInputStream(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
        byte[] byArray = new byte[1024];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
            l += (long)n;
        }
        bufferedOutputStream.close();
        Updater.verifyFile(string2, string3);
    }

    private static void verifyFile(String string, String string2) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = StringUtils.parseHexString(string2);
        byte[] byArray2 = Updater.readFile(string);
        byte[] byArray3 = messageDigest.digest(byArray2);
        if (!Updater.byteArrayEqual(byArray3, byArray)) {
            throw new Exception("File Verification Mismatch for: " + string + "\n" + "Got: " + StringUtils.toHexString(byArray3) + "\n" + "Should've Got: " + StringUtils.toHexString(byArray));
        }
    }

    private static byte[] readFile(String string) throws IOException {
        FileChannel fileChannel = new RandomAccessFile(string, "rw").getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, fileChannel.size());
        byte[] byArray = new byte[mappedByteBuffer.capacity()];
        mappedByteBuffer.get(byArray);
        fileChannel.close();
        return byArray;
    }

    private static boolean byteArrayEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

