/*
 * Decompiled with CFR 0.152.
 */
package lawnlogin;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import lawnlogin.BackgroundThread;
import lawnlogin.FormWorker;
import lawnlogin.ui.LawnLoginXGUI;

public class LawnLoginX {
    public static final String VERSION = "1.0.1";
    public String username = null;
    public String password = null;
    public short status;
    public boolean enableFirewall = true;
    public FormWorker formWorker;
    public String configFilename = "LawnLoginX.conf";
    private String wirelessInfoCmd = "/System/Library/PrivateFrameworks/Apple80211.framework/Versions/Current/Resources/airport -I";
    public int nonLawnPollingPeriod = 30;
    public int notLoggedInLawnPollingPeriod = 15;
    public int loggedInLawnPollingPeriod = 45;
    protected BackgroundThread backgroundThread;
    public LawnLoginXGUI gui = null;

    public static void main(String[] stringArray) throws Exception {
        LawnLoginX lawnLoginX = LawnLoginX.processCommandLine(stringArray);
        lawnLoginX.updateStatus();
        if (lawnLoginX.status == 1) {
            lawnLoginX.login();
        }
    }

    public void login() throws Exception {
        if (this.gui != null && this.gui.activity != null) {
            this.gui.activity.setText(FormWorker.activityCodeToActivity((short)1));
            this.gui.activity.repaint();
        }
        boolean bl = this.formWorker.login(this.username, this.password, this.enableFirewall);
        this.updateStatus(bl);
        if (this.gui != null && this.gui.activity != null) {
            this.gui.activity.setText(FormWorker.activityCodeToActivity((short)0));
            this.gui.activity.repaint();
        }
    }

    public static LawnLoginX processCommandLine(String[] stringArray) throws Exception {
        return LawnLoginX.processCommandLine(stringArray, null);
    }

    public static LawnLoginX processCommandLine(String[] stringArray, LawnLoginXGUI lawnLoginXGUI) throws Exception {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if ("-u".equals(stringArray[i])) {
                string = stringArray[++i];
                continue;
            }
            if ("-p".equals(stringArray[i])) {
                string2 = stringArray[++i];
                continue;
            }
            if ("-c".equals(stringArray[i])) {
                string3 = stringArray[++i];
                continue;
            }
            if ("-d".equals(stringArray[i])) {
                bl = false;
                continue;
            }
            if (!"-h".equals(stringArray[i]) && !"-help".equals(stringArray[i]) && !"--help".equals(stringArray[i])) continue;
            LawnLoginX.usage();
        }
        LawnLoginX lawnLoginX = null;
        if (string3 == null && (string == null || string2 == null) && lawnLoginXGUI == null) {
            LawnLoginX.usage();
        } else {
            lawnLoginX = string3 != null ? new LawnLoginX(string3) : (string != null && string2 != null ? new LawnLoginX(string, string2, bl) : new LawnLoginX());
        }
        if (lawnLoginXGUI != null) {
            lawnLoginX.gui = lawnLoginXGUI;
        }
        return lawnLoginX;
    }

    public static void usage() {
        System.out.println("LAWNLoginX Usage:");
        System.out.println("java LawnLoginX -c configurationFilename");
        System.out.println("java LawnLoginX -u username -p password [-d]");
        System.out.println("-d disables the inbound firewall");
        System.exit(-1);
    }

    public LawnLoginX() throws FileNotFoundException, IOException, Exception {
        String string = System.getProperty("os.name");
        this.formWorker = new FormWorker();
        if (string.startsWith("Linux")) {
            this.setWirelessInfoCmd("/sbin/iwconfig");
        }
        this.loadPreferences(this.configFilename);
        this.backgroundThread = new BackgroundThread(this);
        new Thread(this.backgroundThread).start();
    }

    public LawnLoginX(String string) throws Exception {
        String string2 = System.getProperty("os.name");
        this.formWorker = new FormWorker();
        if (string2.startsWith("Linux")) {
            this.setWirelessInfoCmd("/sbin/iwconfig");
        }
        this.configFilename = string;
        this.loadPreferences(string);
        this.backgroundThread = new BackgroundThread(this);
        new Thread(this.backgroundThread).start();
    }

    public void loadPreferences(String string) throws IOException, FileNotFoundException {
        Properties properties = new Properties();
        if (!new File(string).exists()) {
            System.err.println("WARNING: Configuration Filename: " + string + " doesn't exist.");
            return;
        }
        properties.load(new FileInputStream(string));
        if (properties.containsKey("username")) {
            this.username = properties.getProperty("username");
        }
        if (properties.containsKey("password")) {
            this.password = properties.getProperty("password");
        }
        if (properties.containsKey("disableFirewall")) {
            boolean bl = this.enableFirewall = !Boolean.parseBoolean(properties.getProperty("disableFirewall"));
        }
        if (properties.containsKey("wirelessInfoCmd")) {
            this.setWirelessInfoCmd(properties.getProperty("wirelessInfoCmd"));
        }
        if (properties.containsKey("nonLawnPollingPeriod")) {
            this.nonLawnPollingPeriod = Integer.parseInt(properties.getProperty("nonLawnPollingPeriod"));
        }
        if (properties.containsKey("loggedInLawnPollingPeriod")) {
            this.loggedInLawnPollingPeriod = Integer.parseInt(properties.getProperty("loggedInLawnPollingPeriod"));
        }
        if (properties.containsKey("notLoggedInLawnPollingPeriod")) {
            this.notLoggedInLawnPollingPeriod = Integer.parseInt(properties.getProperty("notLoggedInLawnPollingPeriod"));
        }
    }

    public LawnLoginX(String string, String string2, boolean bl) throws Exception {
        this();
        this.username = string;
        this.password = string2;
        this.enableFirewall = bl;
    }

    public void savePreferences() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("username", this.username);
        properties.setProperty("password", this.password);
        properties.setProperty("disableFirewall", new Boolean(!this.enableFirewall).toString());
        properties.setProperty("wirelessInfoCmd", this.wirelessInfoCmd);
        properties.setProperty("loggedInLawnPollingPeriod", new Integer(this.loggedInLawnPollingPeriod).toString());
        properties.setProperty("nonLawnPollingPeriod", new Integer(this.nonLawnPollingPeriod).toString());
        properties.setProperty("notLoggedInLawnPollingPeriod", new Integer(this.notLoggedInLawnPollingPeriod).toString());
        properties.store(new FileOutputStream(this.configFilename), "LawnLoginX Config File generated by LawnLoginX version 1.0.1");
    }

    public void updateStatus() throws IOException, InterruptedException {
        this.updateStatus(false);
    }

    public void updateStatus(boolean bl) throws IOException, InterruptedException {
        if (this.gui != null && this.gui.activity != null) {
            this.gui.activity.setText(FormWorker.activityCodeToActivity((short)2));
            this.gui.activity.repaint();
        }
        this.status = this.formWorker.checkLAWNStatus();
        Color color = new Color(0, 128, 0);
        if (this.gui != null && this.gui.status != null) {
            this.gui.status.setText(FormWorker.statusCodeToStatus(this.status));
            if (this.status == 0) {
                this.gui.status.setBackground(Color.BLACK);
                this.gui.status.setForeground(Color.RED);
                this.gui.status.setIcon(this.gui.nonLawnIcon);
            } else if (this.status == 1) {
                this.gui.status.setBackground(Color.WHITE);
                this.gui.status.setForeground(Color.RED);
                this.gui.status.setIcon(this.gui.notLoggedInIcon);
            } else if (this.status == 2) {
                this.gui.status.setBackground(Color.WHITE);
                this.gui.status.setForeground(color);
                this.gui.status.setIcon(this.gui.loggedInIcon);
            }
            if (this.status == 1) {
                this.gui.loginButton.setEnabled(true);
            } else {
                this.gui.loginButton.setEnabled(false);
            }
        } else {
            System.out.println("Status: " + FormWorker.statusCodeToStatus(this.status));
        }
        if (this.gui != null && this.gui.activity != null) {
            this.gui.activity.setText(FormWorker.activityCodeToActivity((short)0));
            this.gui.activity.repaint();
        }
    }

    public String getWirelessInfoCmd() {
        return this.wirelessInfoCmd;
    }

    public void setWirelessInfoCmd(String string) {
        this.formWorker.wirelessInfoCmd = this.wirelessInfoCmd = string;
    }
}

