/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovy.lang.MetaMethod;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import java.util.List;
import org.codehaus.groovy.classgen.BytecodeHelper;

public class ReflectorGenerator
implements Opcodes {
    private List methods;
    private ClassVisitor cv;
    private BytecodeHelper helper = new BytecodeHelper(null);
    private String classInternalName;

    public ReflectorGenerator(List methods) {
        this.methods = methods;
    }

    public void generate(ClassVisitor cv, String className) {
        this.cv = cv;
        this.classInternalName = BytecodeHelper.getClassInternalName(className);
        cv.visit(47, 33, this.classInternalName, null, "org/codehaus/groovy/runtime/Reflector", null);
        MethodVisitor mv = cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/codehaus/groovy/runtime/Reflector", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        this.generateInvokeMethod();
        cv.visitEnd();
    }

    protected void generateInvokeMethod() {
        MetaMethod method;
        int i;
        int methodCount = this.methods.size();
        MethodVisitor mv = this.cv.visitMethod(1, "invoke", "(Lgroovy/lang/MetaMethod;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "groovy/lang/MetaMethod", "getMethodIndex", "()I");
        Label defaultLabel = new Label();
        Label[] labels = new Label[methodCount];
        int[] indices = new int[methodCount];
        for (i = 0; i < methodCount; ++i) {
            labels[i] = new Label();
            method = (MetaMethod)this.methods.get(i);
            method.setMethodIndex(i + 1);
            indices[i] = method.getMethodIndex();
        }
        mv.visitLookupSwitchInsn(defaultLabel, indices, labels);
        for (i = 0; i < methodCount; ++i) {
            mv.visitLabel(labels[i]);
            mv.visitMethodInsn(183, this.classInternalName, "m" + i, "(Lgroovy/lang/MetaMethod;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitInsn(176);
        }
        mv.visitLabel(defaultLabel);
        mv.visitMethodInsn(182, this.classInternalName, "noSuchMethod", "(Lgroovy/lang/MetaMethod;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(4, 4);
        mv.visitEnd();
        for (i = 0; i < methodCount; ++i) {
            mv = this.cv.visitMethod(2, "m" + i, "(Lgroovy/lang/MetaMethod;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            this.helper = new BytecodeHelper(mv);
            method = (MetaMethod)this.methods.get(i);
            this.invokeMethod(method, mv);
            if (method.getReturnType() == Void.TYPE) {
                mv.visitInsn(1);
            }
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    protected void invokeMethod(MetaMethod method, MethodVisitor mv) {
        Class callClass = method.getInterfaceClass();
        boolean useInterface = false;
        if (callClass == null) {
            callClass = method.getCallClass();
        } else {
            useInterface = true;
        }
        String type = BytecodeHelper.getClassInternalName(callClass.getName());
        String descriptor = BytecodeHelper.getMethodDescriptor(method.getReturnType(), method.getParameterTypes());
        if (method.isStatic()) {
            this.loadParameters(method, 3, mv);
            mv.visitMethodInsn(184, type, method.getName(), descriptor);
        } else {
            mv.visitVarInsn(25, 2);
            this.helper.doCast(callClass);
            this.loadParameters(method, 3, mv);
            mv.visitMethodInsn(useInterface ? 185 : 182, type, method.getName(), descriptor);
        }
        this.helper.box(method.getReturnType());
    }

    protected void loadParameters(MetaMethod method, int argumentIndex, MethodVisitor mv) {
        Class[] parameters = method.getParameterTypes();
        int size = parameters.length;
        for (int i = 0; i < size; ++i) {
            mv.visitVarInsn(25, argumentIndex);
            this.helper.pushConstant(i);
            mv.visitInsn(50);
            Class type = parameters[i];
            if (type.isPrimitive()) {
                this.helper.unbox(type);
                continue;
            }
            this.helper.doCast(type);
        }
    }
}

